//
//  GSDocView.h
//  GSCommonKit
//
//  Created by Gaojin Hsu on 7/7/17.
//  Copyright © 2017 Geensee. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "GSDocAnnoProtocol.h"
#import <GSCommonKit/GSWebAccess.h>
#import <GSCommonKit/GSWatermarkView.h>
#import <GSCommonKit/GSWeakProxy.h>
#import "GSAnnoType.h"
#import "GSDocument.h"
typedef NS_ENUM(NSInteger, GSDocumentType)
{
    GSDocumentTypeUnknow        =   0x00,
    GSDocumentTypePPT           =   0x01,
    GSDocumentTypeWORD          =   0x02,
    GSDocumentTypeTXT           =   0x03,
    GSDocumentTypeEXCEL         =   0x04,
    GSDocumentTypeJPEG          =   0x05,
    GSDocumentTypeEMF           =   0x06,
    GSDocumentTypePDF           =   0x07,
    GSDocumentTypeBMP           =   0x08,
    GSDocumentTypeSWF           =   0x09,
    GSDocumentTypePPTX          =   0x0a,
    GSDocumentTypeSWF_VERYDOC   =   0x10,
    GSDocumentTypeWHITEBOARD    =   0x20,
    GSDocumentTypeBLACKBOARD_DEFAULT    =   0x30,
    GSDocumentTypeBLACKBOARD            =   0x40

};

typedef NS_ENUM(NSInteger, GSDocumentBLACKBOARDTYPE)
{
    GSDocumentBLACKBOARDTYPE_DEFAULT    =   GSDocumentTypeBLACKBOARD_DEFAULT,
    GSDocumentBLACKBOARDTYPE_NORMAL            =   GSDocumentTypeBLACKBOARD
};

//文档显示模式
typedef NS_ENUM(NSUInteger, GSDocViewShowMode) {
    GSDocViewShowModeScaleAspectFit, //等比缩放显示（所有内容会全部显示在区域内）
    GSDocViewShowModeScaleToFill,    //拉伸全屏显示
    GSDocViewShowModeWidthFit,       //宽度适配屏幕，即宽度铺满，高度不够则中心显示，超出则上下拖动
    GSDocViewShowModeHeightFit,      //高度适配屏幕，即高度铺满，宽度不够则中心显示，超出则左右拖动
};

//old 文档显示模式
typedef NS_ENUM(NSInteger, GSDocShowType){
    GSDocEqualHighType = 0x01, //等高
    GSDocEqualWidthType, //等宽
    GSDocEqualFullScreenType, //全屏
};

@class GSDocView;
@protocol GSDocViewDelegate <NSObject>
@optional
-(void)docView:(GSDocView*)docView onSingleTap:(UITapGestureRecognizer*)TapGestureRecognizer;
- (BOOL)docView:(GSDocView*)docview gestureRecognizerShouldBegin:(UIGestureRecognizer *)gestureRecognizer;//是否应该响应手势,小窗口不响应
- (void)docView:(GSDocView*)docview anno:(GSAnnoBase*)anno pageID:(unsigned int)pageID docID:(unsigned int)docID DEPRECATED_MSG_ATTRIBUTE("用户不用实现该接口，后面将删除，SDK内部会处理数据的发送");
- (void)docView:(GSDocView *)docview pageAnimationCount:(int)animationCount;//返回当前页文档包含的动画步骤
- (void)docView:(GSDocView *)docview undoCount:(int)undoCount redoCount:(int)redoCount;//返回undo redo数组中的记录数量
- (void)docViewSlideToLeft:(GSDocView*)docView;//检测到文档向左滑动
- (void)docViewSlideToRight:(GSDocView *)docView;//检车文档向右滑动
- (void)docViewSlideBorder:(GSDocView*)docView position:(float)position isEnd:(BOOL)isEnd;
- (void)docViewSlideState:(GSDocView*)docView recongnizer:(UIPanGestureRecognizer*)recongnizer;
//old
- (void)docViewOpenFinishSuccess:(GSDocPage*)page docID:(unsigned)docID;
- (void)docViewStepBackNextEnable:(int)backNum nextNum:(int)nextNum DEPRECATED_MSG_ATTRIBUTE("use 'docView:undoCount:redoCount:'"); //可以撤销的步骤数backNum，可以还原的步骤数nextNum
@end

//文档view
@interface GSDocView : UIView <GSDocAnnoProtocol>
@property (nonatomic, assign) GSDocViewShowMode showMode;//显示模式
@property (nonatomic, weak) id<GSDocViewDelegate> delegate;
@property (nonatomic, strong) GSDocPage* currentPage;
@property (nonatomic, assign) NSUInteger limitTextureCount; //TextureCount 如果超过的话，OpenFile返回false, TextureCount =0，不限制
@property (nonatomic, assign) BOOL touchEventEnabled; //是否向下传递touchEvent事件，默认为YES
@property (nonatomic, assign) BOOL isAnnomationMode;//自己能否画标注
@property (nonatomic, assign) GSDocumentAnnoType docAnnoType;//要画的标注类型
@property (nonatomic, assign) Byte lineExType;//当docAnnoType设置为GSDocumentAnnoTypeLineEx时，用这个来设置线的样式，箭头线2，虚线1和普通线0
@property (nonatomic, assign) Byte pointExType;//当docAnnoType设置为GSDocumentAnnoTypePointEx时，用这个来设置点的样式，0十字 1箭头
@property (nonatomic, assign) NSUInteger lineSize;//线的粗细
@property (nonatomic, strong) UIColor *lineColor;//线的颜色
@property (assign, nonatomic) BOOL isRoleTeacher; //老师角色可删除其他人的标注，否则只能删除自己的标注
@property (assign, nonatomic) long long myUserID;
@property (assign, nonatomic) BOOL isSlideToPosition;//针对网络会议特殊处理，与UIScrollView嵌套使用，存在事件冲突的问题
@property (nonatomic, copy) void(^goSendAnnoDataBlock)(GSDocView* docview, GSAnnoBase* anno, unsigned int pageID, unsigned int docID);//主动绘制标注时数据回调，RtSDK使用
@property (nonatomic, copy) void(^goModifyAnnoDataBlock)(GSDocView* docview, GSAnnoBase* anno, unsigned int pageID, unsigned int docID);//主动修改标注时数据回调，RtSDK使用
///水印视图
@property (nonatomic, strong) GSWatermarkView *watermarkView;

/// 文档内容图片（png格式,不包括批注）
@property (nonatomic, strong) CIImage * docPageImage;
/// 合并内容和批注图片
- (CIImage *)getDocPageAndAnnoRenderIamge;

- (void)setBackgroundColor:(int)red
                     green:(int)green
                      blue:(int)blue; //设置背景色(r,g,b : 0-255)

//切换文档页
-(void)switchPage:(GSDocPage*)page animationStep:(int)step;
-(void)goToAnimationStep:(int)step;
-(void)drawPageAnno:(GSAnnoBase*)anno;



//清除视图上的所有的标注(内部方法即清楚上面的所有的layer)
-(void)docCleanAllAnnos;
- (void)docCloseAnyway;
- (void)redo;//恢复
- (void)undo;//撤销
- (void)cleanAllAnnos; //清除所有标注（如果是老师角色，删除所有标注；如果是非老师角色，删除自己的标注), 橡皮擦（清除单笔标注）使用docAnnoType

//增加文字标注
-(void)addTextAnno:(GSAnnoInputText*)annoText;
//增加图片标注
-(void)addPictureAnno:(GSAnnoInputPicture*)pictureText;

//old
- (int)getCurrentDocAnnoStepCount;
- (int)getNextAnimation;


-(void)updateAnnoId:(GSAnnoBase*)pAnno newAnnoId:(long long)newAnnoId;
@property (nonatomic, assign) BOOL isNeedShowPen DEPRECATED_MSG_ATTRIBUTE("弃用");
@property (nonatomic, assign) NSUInteger  gSDocShowType DEPRECATED_MSG_ATTRIBUTE("建议使用showMode"); //文档的显示类型
@property (nonatomic, assign) BOOL zoomEnabled DEPRECATED_MSG_ATTRIBUTE("弃用,use delegate");
@property (nonatomic, assign) BOOL fullMode DEPRECATED_MSG_ATTRIBUTE("弃用");
@property (assign, nonatomic) BOOL isVectorScale DEPRECATED_MSG_ATTRIBUTE("弃用");
@property (nonatomic, weak) id<GSDocViewDelegate> docDelegate DEPRECATED_MSG_ATTRIBUTE("弃用");
- (void)setGlkBackgroundColor:(int)red green:(int)green blue:(int)blue DEPRECATED_MSG_ATTRIBUTE("use 'setBackgroundColor:green:blue:'");
- (void)enablePanGes:(BOOL)enable DEPRECATED_MSG_ATTRIBUTE("弃用");
- (void)clearPageAndAnno DEPRECATED_MSG_ATTRIBUTE("弃用");
//设置线的颜色
- (void)setupDocAnnoColor:(UIColor*)annoColor DEPRECATED_MSG_ATTRIBUTE("use 'lineColor'");
//设置线的粗细
- (void)setupDocAnnoLineSize:(Byte)LineSize DEPRECATED_MSG_ATTRIBUTE("use 'lineSize'");
//设置需要绘制那种标注线型
- (void)setupDocAnnoType:(GSDocumentAnnoType)annoType DEPRECATED_MSG_ATTRIBUTE("use 'docAnnoType'");
//设置线的类型
- (void)setupLineExAnnoType:(LineExAnnoType)lineType DEPRECATED_MSG_ATTRIBUTE("use 'lineExType'");
//设置PointEx的显示类型
- (void)setupPointExType:(GSDocumentPointExAnnoType)pointExType DEPRECATED_MSG_ATTRIBUTE("use 'pointExType'");

//释放SWF的渲染
- (void)releaseSwfRender ;
@end
